/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shadows;

import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.gl.texture.DepthBufferFormat;
import net.coderbot.iris.gl.texture.DepthCopyStrategy;
import net.coderbot.iris.gl.texture.InternalTextureFormat;
import net.coderbot.iris.rendertarget.DepthTexture;
import net.coderbot.iris.rendertarget.RenderTarget;
import net.coderbot.iris.shaderpack.PackShadowDirectives;

public class ShadowRenderTargets {
    private final RenderTarget[] targets;
    private final DepthTexture mainDepth;
    private final DepthTexture noTranslucents;
    private final GlFramebuffer depthSourceFb;
    private final GlFramebuffer noTranslucentsDestFb;
    private final GlFramebuffer mainRenderBuffer;
    private final boolean[] flipped;
    private final List<GlFramebuffer> ownedFramebuffers;
    private final int resolution;
    private boolean fullClearRequired;
    private boolean translucentDepthDirty;
    private boolean[] hardwareFiltered;
    private InternalTextureFormat[] formats;
    private IntList buffersToBeCleared;

    public ShadowRenderTargets(int n, PackShadowDirectives packShadowDirectives) {
        int n2;
        this.targets = new RenderTarget[packShadowDirectives.getColorSamplingSettings().size()];
        this.formats = new InternalTextureFormat[packShadowDirectives.getColorSamplingSettings().size()];
        this.flipped = new boolean[packShadowDirectives.getColorSamplingSettings().size()];
        this.hardwareFiltered = new boolean[packShadowDirectives.getColorSamplingSettings().size()];
        this.buffersToBeCleared = new IntArrayList();
        this.mainDepth = new DepthTexture(n, n, DepthBufferFormat.DEPTH);
        this.noTranslucents = new DepthTexture(n, n, DepthBufferFormat.DEPTH);
        int[] nArray = new int[packShadowDirectives.getColorSamplingSettings().size()];
        for (n2 = 0; n2 < packShadowDirectives.getColorSamplingSettings().size(); ++n2) {
            PackShadowDirectives.SamplingSettings samplingSettings = (PackShadowDirectives.SamplingSettings)packShadowDirectives.getColorSamplingSettings().get(n2);
            this.targets[n2] = RenderTarget.builder().setDimensions(n, n).setInternalFormat(samplingSettings.getFormat()).setPixelFormat(samplingSettings.getFormat().getPixelFormat()).build();
            this.formats[n2] = samplingSettings.getFormat();
            if (samplingSettings.getClear()) {
                this.buffersToBeCleared.add(n2);
            }
            nArray[n2] = n2;
            if (!samplingSettings.getClear()) continue;
            this.buffersToBeCleared.add(n2);
        }
        for (n2 = 0; n2 < packShadowDirectives.getDepthSamplingSettings().size(); ++n2) {
            this.hardwareFiltered[n2] = ((PackShadowDirectives.DepthSamplingSettings)packShadowDirectives.getDepthSamplingSettings().get(n2)).getHardwareFiltering();
        }
        this.resolution = n;
        this.ownedFramebuffers = new ArrayList<GlFramebuffer>();
        this.fullClearRequired = true;
        this.depthSourceFb = this.createFramebufferWritingToMain(new int[]{0});
        this.mainRenderBuffer = this.createFramebufferWritingToMain(nArray);
        this.mainRenderBuffer.addDepthAttachment(this.mainDepth.getTextureId());
        this.noTranslucentsDestFb = this.createFramebufferWritingToMain(new int[]{0});
        this.noTranslucentsDestFb.addDepthAttachment(this.noTranslucents.getTextureId());
        this.translucentDepthDirty = true;
    }

    public void flip(int n) {
        this.flipped[n] = !this.flipped[n];
    }

    public boolean isFlipped(int n) {
        return this.flipped[n];
    }

    public void destroy() {
        for (GlFramebuffer glFramebuffer : this.ownedFramebuffers) {
            glFramebuffer.destroy();
        }
        for (RenderTarget renderTarget : this.targets) {
            renderTarget.destroy();
        }
        this.mainDepth.destroy();
        this.noTranslucents.destroy();
    }

    public int getRenderTargetCount() {
        return this.targets.length;
    }

    public RenderTarget get(int n) {
        return this.targets[n];
    }

    public int getResolution() {
        return this.resolution;
    }

    public DepthTexture getDepthTexture() {
        return this.mainDepth;
    }

    public DepthTexture getDepthTextureNoTranslucents() {
        return this.noTranslucents;
    }

    public GlFramebuffer getDepthSourceFb() {
        return this.depthSourceFb;
    }

    public void copyPreTranslucentDepth() {
        if (this.translucentDepthDirty) {
            this.translucentDepthDirty = false;
            IrisRenderSystem.blitFramebuffer(this.depthSourceFb.getId(), this.noTranslucentsDestFb.getId(), 0, 0, this.resolution, this.resolution, 0, 0, this.resolution, this.resolution, 256, 9728);
        } else {
            DepthCopyStrategy.fastest(false).copy(this.depthSourceFb, this.mainDepth.getTextureId(), this.noTranslucentsDestFb, this.noTranslucents.getTextureId(), this.resolution, this.resolution);
        }
    }

    public boolean isFullClearRequired() {
        return this.fullClearRequired;
    }

    public void onFullClear() {
        this.fullClearRequired = false;
    }

    public GlFramebuffer createFramebufferWritingToMain(int[] nArray) {
        return this.createFullFramebuffer(false, nArray);
    }

    public GlFramebuffer createFramebufferWritingToAlt(int[] nArray) {
        return this.createFullFramebuffer(true, nArray);
    }

    private ImmutableSet<Integer> invert(ImmutableSet<Integer> immutableSet, int[] nArray) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (int n : nArray) {
            if (immutableSet.contains((Object)n)) continue;
            builder.add((Object)n);
        }
        return builder.build();
    }

    private GlFramebuffer createEmptyFramebuffer() {
        GlFramebuffer glFramebuffer = new GlFramebuffer();
        this.ownedFramebuffers.add(glFramebuffer);
        glFramebuffer.addDepthAttachment(this.mainDepth.getTextureId());
        glFramebuffer.addColorAttachment(0, this.get(0).getMainTexture());
        glFramebuffer.noDrawBuffers();
        return glFramebuffer;
    }

    public GlFramebuffer getMainRenderBuffer() {
        return this.mainRenderBuffer;
    }

    public GlFramebuffer createShadowFramebuffer(ImmutableSet<Integer> immutableSet, int[] nArray) {
        if (nArray.length == 0) {
            return this.createEmptyFramebuffer();
        }
        ImmutableSet<Integer> immutableSet2 = this.invert(immutableSet, nArray);
        GlFramebuffer glFramebuffer = this.createColorFramebuffer(immutableSet2, nArray);
        glFramebuffer.addDepthAttachment(this.mainDepth.getTextureId());
        return glFramebuffer;
    }

    private GlFramebuffer createFullFramebuffer(boolean bl, int[] nArray) {
        if (nArray.length == 0) {
            return this.createEmptyFramebuffer();
        }
        ImmutableSet<Integer> immutableSet = ImmutableSet.of();
        if (!bl) {
            immutableSet = this.invert((ImmutableSet<Integer>)ImmutableSet.of(), nArray);
        }
        return this.createColorFramebufferWithDepth(immutableSet, nArray);
    }

    public GlFramebuffer createColorFramebufferWithDepth(ImmutableSet<Integer> immutableSet, int[] nArray) {
        GlFramebuffer glFramebuffer = this.createColorFramebuffer(immutableSet, nArray);
        glFramebuffer.addDepthAttachment(this.mainDepth.getTextureId());
        return glFramebuffer;
    }

    public GlFramebuffer createColorFramebuffer(ImmutableSet<Integer> immutableSet, int[] nArray) {
        int n;
        if (nArray.length == 0) {
            throw new IllegalArgumentException("Framebuffer must have at least one color buffer");
        }
        GlFramebuffer glFramebuffer = new GlFramebuffer();
        this.ownedFramebuffers.add(glFramebuffer);
        int[] nArray2 = new int[nArray.length];
        for (n = 0; n < nArray.length; ++n) {
            nArray2[n] = n;
            if (nArray[n] >= this.getRenderTargetCount()) {
                throw new IllegalStateException("Render target with index " + nArray[n] + " is not supported, only " + this.getRenderTargetCount() + " render targets are supported.");
            }
            RenderTarget renderTarget = this.get(nArray[n]);
            int n2 = immutableSet.contains((Object)nArray[n]) ? renderTarget.getMainTexture() : renderTarget.getAltTexture();
            glFramebuffer.addColorAttachment(n, n2);
        }
        glFramebuffer.drawBuffers(nArray2);
        glFramebuffer.readBuffer(0);
        n = glFramebuffer.getStatus();
        if (n != 36053) {
            throw new IllegalStateException("Unexpected error while creating framebuffer");
        }
        return glFramebuffer;
    }

    public int getColorTextureId(int n) {
        return this.isFlipped(n) ? this.get(n).getAltTexture() : this.get(n).getMainTexture();
    }

    public boolean isHardwareFiltered(int n) {
        return this.hardwareFiltered[n];
    }

    public int getNumColorTextures() {
        return this.targets.length;
    }

    public InternalTextureFormat getColorTextureFormat(int n) {
        return this.formats[n];
    }

    public ImmutableSet<Integer> snapshot() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (int i = 0; i < this.flipped.length; ++i) {
            if (!this.flipped[i]) continue;
            builder.add((Object)i);
        }
        return builder.build();
    }

    public IntList getBuffersToBeCleared() {
        return this.buffersToBeCleared;
    }
}

